//
//  LSNonAnotoFile.h
//  LDMac
//
//  Created by Marcel Weiher on 6/24/10.
//  Copyright 2010 Livescribe. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <MPWFoundation/PhoneGeometry.h>
#import "LSStorageManager.h"

//#import "LSAnotoFile.h"
//#import "LSNonAnotoFile.h"

@class GridFile, StrokeList, LSImageList, AudioModel;
@class LSZipFile, MPWMAXParser, StrokeList;

@interface LSNonAnotoFile : NSObject {
	LSZipFile				*theZip;
	MPWMAXParser			*documentParser;
	NSDictionary			*_infoDict;
	NSMutableArray			*_pageInfos;
	NSString				*_patternStartString;
	NSString				*_path;
	NSMutableDictionary		*_sessionInfoFiles;
}

+ (float)au2pt:(float)au;
- (float)au2pt:(float)au;
+ (float)pt2au:(float)au;
- (float)pt2au:(float)au;

objectAccessor_h( LSZipFile*, theZip, setTheZip )
objectAccessor_h( MPWMAXParser*, documentParser, setDocumentParser )
objectAccessor_h( NSDictionary*, _infoDict, setInfoDict )
objectAccessor_h( NSArray *, _pageInfos, setPageInfos )
objectAccessor_h( NSString *, _patternStartString, setPatternStartString )

- (void) initializeSessionInfoFilesDictionary;
- (NSDictionary *)parseInfoDict;
- (NSDictionary *)infoDict;
- (NSSize)size;
- afdVersion;
- directoryContentsAtBasePath:(NSString *)zipPath;
- directoryContentsAtPath:(NSString *)zipPath;
- dataForUserDataAtPath:(NSString *)zipPath;
- anotoLock;
- (NSArray *)dataForUserDataDirectoryNamed:(NSString *)subdirectoryName;
- (NSArray *)backgroundImageDatas;
- (void)writeData:(NSData *)data 
		 atPath:(NSString *)path;
- (void)deleteFile:path;
- (void)copyStrokesFromPage:(int)pageNo document:aDoc forPenId:penid;
- (void)saveStrokes:strokes atPage:(int)pageNo forPenId:penid;
- (int)numPages;
- (int)totalPages;
- (int)pageNumberOffset;
- (NSString*)dataDirPathForPage:(int)page;
- (NSArray *)dataPathsForPage:(int)page;
- (NSArray *)strokesForSTFData:(NSData *)stfData;
- (StrokeList *)loadStrokesForPage:(int)i 
					 gridFile:(GridFile *)aGridFile 
			    timeBoundsArray:(NSArray *)timeBoundsArray
					  afdCopy:(int)copy;
- (StrokeList *)loadStrokesForPage:(int)i 
					 gridFile:(GridFile *)aGridFile 
				  sessionPages:(NSArray *)sessionPages
					  afdCopy:(int)copy;
- (StrokeList *)loadStrokesForPage:(int)i 
					 gridFile:(GridFile *)aGridFile
					  afdCopy:(int)copy;
- (NSString *)uploadAacFilePath;
- (NSArray *)uploadAacFileNames;
- (NSString *)uploadSessionName;
- (NSData *)uploadSessionInfoFileForSession:(NSString *)sessionName;
- (NSData *)uploadSessionInfoXmlFileForSession:(NSString *)sessionName;
- (NSData *)uploadSessionPagesFileForSession:(NSString *)sessionName;
- (NSData *)uploadGridFileForPageAddress:(long long)pageAddress;
- (NSRect)boundingBoxForPage:(int)i;
-(void)extractAudioFilesForSessionNamed:(NSString*)mySession toDirectory:(NSString*)tempDir;
-(SessionInfoFile*)sessionInfoAtIndex:(int)sessionIndex;
-(NSArray*)sessionsDir;
-(NSString*)sessionPathAtIndex:(int)sessionIndex;
-(int)numberOfSessions;
- (void)dealloc;

#if 1
objectAccessor_h( NSString *,_path,setPath )
+ (NSString *)serializedPageAddress:(long long)srcAddress;
+ (NSString *)gridFileNameForPageAddress:(long long)address;
- initWithPath:(NSString *)thePath 
    forWriting:(BOOL)writing;
- initWithPath:(NSString *)zipPath;
+ (id)anotoFileWithPath:(NSString *)aPath;
- pageElement:children 
   attributes:attrs 
	  parser:parser;
- itemElement:children 
   attributes:attrs 
	  parser:parser;
- dataAtPath:(NSString *)zipPath;
- pageInfos;
- pageInfoForPage:(int)page;
- (NSString *)templateBasePathForPage:(int)i;
- (NSString *)patternStartString;
- (NSString *)patternAddressForPage:(int)pageNo
					   afdCopy:(int)copy;
- (NSString *)patternAddressForPage:(int)pageNo;
#endif

#if !TARGET_OS_IPHONE
-(AudioModel*)audioModelForSessionAtIndex:(int)sessionIndex;
#endif

@end

@interface LSNonAnotoFile(testing)

+(id)anotoFileWithTestResourceName:afdName type:(NSString*)type;
+(id)anotoFileWithTestResourceName:afdName;
+(void)testStrokeDetails;
+(void)testAfdInfos;
+(void)testDirectSubdirectoryAccess;
+(void)testPatternAddress;
+(void)testDataFilePaths;
+(void)testReadOfCannedUploadInfo;
+(void)testUploadFileReading;
+(void)testCanUniquePageTemplates;
+(void)testSerializedPageAddress;
+(void)testGridfileName;
+(void)testPageAddressForPage;
+(void)testBoundingBoxForPage;
+(void)testConvertAnotoUnits;
+(void)testNonExistentFileShouldReturnNil;
+(void)testSessionPaths;
+(void)testSessionInfo;
+(void)testExtractAudioFilesForSession;
+testSelectors;

@end
